/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_05; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class RemoteDominoWithToken implements Runnable {
	static String host = "www.djbuch.de:63148",
		user = "Thomas Ekert/DJBUCH", pwd = "geheim";
	static final String [] args = new String [1];
	static {args [0] = "-ORBEnableSSLSecurity";}
	
	public static void main(String argv[]) throws InterruptedException {
		RemoteDominoWithToken t = new RemoteDominoWithToken();
		Thread nt = new Thread((Runnable) t);
		nt.start();
		nt.join();
		System.out.println ("done everything.");
	}

	public void run() {
		String token = null;
		Session firstSession = null;
		try {
			firstSession = NotesFactory.createSession(host, user, pwd);
			token = firstSession.getSessionToken();
			printInfo(firstSession);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			recycleSession(firstSession);
		}
		Session otherSession = null;
		try {
			String host2 = "127.0.0.1:63148";
			otherSession = NotesFactory.createSession(host2, args, token);
			printInfo(otherSession);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			recycleSession(otherSession);
		}			
	}

	private void recycleSession (Session s) {
		try {
			if (s!= null && s.isValid()) {
				s.recycle ();
			}
		} catch (org.omg.CORBA.INV_OBJREF e) {
			//e.printStackTrace(); //ignore. Server might already have closed DIIOP.
		} catch (NotesException e) {
			e.printStackTrace();
		}
	}
	
	private static void printInfo(Session s)
		throws NotesException {
		System.out.println ("SessionClass\t= " + s.getClass().getName());
		System.out.println ("Platform\t\t= " + s.getPlatform());
		System.out.println ("Version\t\t\t= " + s.getNotesVersion());
		System.out.println ("User\t\t\t= " + s.getUserName());
		System.out.println ("Session Token\t= " + s.getSessionToken());
		System.out.println ("Servername\t\t= <<" + s.getServerName() + ">>\n");
	}
}